import { hasLocale, Locale, NextIntlClientProvider } from "next-intl";
import { routing } from "@/i18n/routing";
import { getLocale, getMessages } from "next-intl/server";
import { Providers } from "./providers";
import "../globals.css";
import { Bebas_Neue, Poppins } from "next/font/google";
import { Cairo } from "next/font/google";
import type { Metadata } from "next";
export const metadata: Metadata = {
  title: "Fast Express",
  description:
    "Fast Express شركة متخصصة في خدمات الشحن السريع والآمن عبر البر والجو والبحر. نوفر حلول توصيل موثوقة للأفراد والشركات مع تتبع فوري وأسعار تنافسية لضمان وصول شحناتك بأمان وفي الوقت المحدد.",
};

const cairo = Cairo({
  subsets: ["arabic"],
  weight: ["300", "400", "500", "600", "700", "800", "900"],
});
const bebasNeue = Bebas_Neue({
  weight: "400",
  subsets: ["latin"],
});

const poppins = Poppins({
  weight: ["100", "200", "300", "400", "500", "600", "700", "800", "900"],
  subsets: ["latin"],
});
const RootLayout = async ({
  children,
  params,
}: {
  children: React.ReactNode;
  params: Promise<{ lang: Locale }>;
}) => {
  const [messages, locale] = await Promise.all([getMessages(), getLocale()]);
  const param = await params;
  const { lang } = param;

  const direction = lang === "ar" ? "rtl" : "ltr";

  return (
    <html lang={lang} dir={direction} suppressHydrationWarning>
      <body
        className={`antialiased ${
          lang === "ar"
            ? cairo.className
            : `${bebasNeue.className} ${poppins.className}`
        }`}
      >
        <NextIntlClientProvider messages={messages} locale={lang}>
          <Providers>{children}</Providers>
        </NextIntlClientProvider>
      </body>
    </html>
  );
};

export default RootLayout;
